
#include "dvlled.h"

#include <linux/autoconf.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/timer.h>
#include <linux/cdev.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kdev_t.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/types.h>
#include <linux/platform_device.h>

#include <asm/uaccess.h>

#define LED_DEVICE_NAME  "devolo-LED"

enum {
	TYPE_NONE = 0,
	TYPE_LED,
	TYPE_DUAL_LED,
};

struct dvlled_entry {
    char *name;
    int type;
	int line1;
	int line2;
	int polarity;
};

extern struct platform_device dvl_platform_device;
extern struct platform_driver dvl_platform_driver;

extern struct dvlled_entry global_leds[];

void dvl_led_config_out(int line);
void dvl_led_set(int line, int value);

void dvl_led_probe(struct platform_device *pdev);
void dvl_led_remove(struct platform_device *pdev);
void dvl_led_init(void);

