#ifndef DVLLED_MOD_H
#define DVLLED_MOD_H

#include "dvlled.h"

#include <linux/version.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,33)
#include <generated/autoconf.h>
#else
#include <linux/autoconf.h>
#endif
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/timer.h>
#include <linux/cdev.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kdev_t.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/types.h>
#include <linux/platform_device.h>
#include <linux/slab.h>

#include <asm/uaccess.h>

#ifdef _DVL_USE_LED_TRIGGER_GPIO
#include "ledtrig-gpio.h"
#include <drivers/leds/leds.h>
#endif

#if 1
#include "ledtrig-wifiled.h"
#endif

#ifdef _DVL_USE_GENERIC_LED_TRIGGER
#include "ledtrig-dvl.h"
#endif

#define LED_DEVICE_NAME  "devolo-LED"

enum {
	TYPE_NONE = 0,
	TYPE_LED,
	TYPE_DUAL_LED,
    TYPE_MIRRORED_LED,
};

/* Low Active / High Active */
typedef enum {
	POL_UNDEF = 0,
	POL_LA = 0,
	POL_HA = 1
} polarity_t;

struct dvlled_entry {
    char *name;
    int type;
	int line1;
	int line2;
	polarity_t polarity;
};

struct dvlled_device
{
	struct led_classdev ancestor;
	
	char name[128];
	int index;
};

struct led_blink_state {
    char *name;
    int valid;
    int ENABLED_STATE_on_ms;
	int ENABLED_STATE_off_ms;
	int DISABLED_STATE_on_ms;
    int DISABLED_STATE_off_ms;
}; 

struct ledblink_entry {
    char*              led_name;
    int                led_type;
    struct led_blink_state*  led_states;
    int                is_activated;
};


//
// Prototypes
//

void dvlled_brightness_set(struct led_classdev *pled, enum led_brightness value);

#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,31)
extern struct platform_device dvl_platform_device;
#else
extern struct platform_device *dvl_platform_device;
#endif

extern struct platform_driver dvl_platform_driver;

extern struct dvlled_entry global_leds[];

#ifdef _DVL_USE_GENERIC_LED_TRIGGER
extern struct ledblink_entry  blink_table[];
#endif

extern int lan_led_idx;
extern int wireless_2g_led_idx;
extern int wireless_5g_led_idx;

void dvl_led_config_out(int line);
void dvl_led_set(int line, int value);
int dvl_led_get(const int gpio);
void set_lan_led(unsigned int on);

void dvl_led_probe(struct platform_device *pdev);
void dvl_led_remove(struct platform_device *pdev);
void dvl_led_init(void);

//Accessable Helper
int num_leds(void);
int getGpioByName(struct led_classdev *led, const char *name);
int getGpioPolByName(struct led_classdev *led, const char* name);
#ifdef _DVL_USE_GENERIC_LED_TRIGGER   
int isTriggerActiveOnLEDByLedName(const char* name);
int setActivateTriggerOnLEDByLedName(const char* name, int activate);
struct led_blink_state* getLedStatesByLedName(const char* name);
#endif

#endif /* DVLLED_MOD_H*/
