#include <common.h>
#include <command.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <config.h>
#include <version.h>
#include "ar7240_soc.h"
#include "memtest.h"

extern void ar7240_ddr_initial_config(uint32_t refresh);
extern int ar7240_ddr_find_size(void);

#ifdef CONFIG_HORNET_EMU
extern void ar7240_ddr_initial_config_for_fpga(void);
#endif

void
ar7240_usb_initial_config(void)
{
#ifndef CONFIG_HORNET_EMU
    ar7240_reg_wr_nf(AR7240_USB_PLL_CONFIG, 0x0a04081e);
    ar7240_reg_wr_nf(AR7240_USB_PLL_CONFIG, 0x0804081e);
#endif
}

void
ar7240_usb_otp_config(void)
{
    unsigned int addr, reg_val, reg_usb;
    int time_out, status, usb_valid;
    
    for (addr = 0xb8114014; ;addr -= 0x10) {
        status = 0;
        time_out = 20;
        
        reg_val = ar7240_reg_rd(addr);

        while ((time_out > 0) && (~status)) {
            if ((( ar7240_reg_rd(0xb8115f18)) & 0x7) == 0x4) {
                status = 1;
            } else {
                status = 0;
            }
            time_out--;
        }

        reg_val = ar7240_reg_rd(0xb8115f1c);
        if ((reg_val & 0x80) == 0x80){
            usb_valid = 1;
            reg_usb = reg_val & 0x000000ff;
        }

        if (addr == 0xb8114004) {
            break;
        }
    }

    if (usb_valid) {
        reg_val = ar7240_reg_rd(0xb8116c88);
        reg_val &= ~0x03f00000;
        reg_val |= (reg_usb & 0xf) << 22;
        ar7240_reg_wr(0xb8116c88, reg_val);
    }
}

void ar7240_gpio_config(void)
{
    //DVL:
    #define ATH_APB_BASE        0x18000000
    #define ATH_GPIO_BASE       ATH_APB_BASE+0x00040000
    #define AR7240_GPIO_FUNC2   ATH_GPIO_BASE+0x30
    #define AR7240_GPIO_FUNC1   ATH_GPIO_BASE+0x28
    /* Disable clock obs 
     * clk_obs1(gpio13/bit8),  clk_obs2(gpio14/bit9), clk_obs3(gpio15/bit10),
     * clk_obs4(gpio16/bit11), clk_obs5(gpio17/bit12)
     * clk_obs0(gpio1/bit19), 6(gpio11/bit20)
     */

#if 1 //DVL: setup gpio for output
    int gpio_inout_map = ar7240_reg_rd(AR7240_GPIO_OE);         //set all explicitly used gpios and leave other ones at their default
    gpio_inout_map |= (1 << 22);                            //set gpio 22 as output for defined AR7420 behaviour (FET on/off)
    gpio_inout_map |= (1 << 20);                            //set gpio 20 as output for defined AR7420 behaviour (reset)
    gpio_inout_map |= (1 << 0);                             //set gpio 0 as output for user status indication
    ar7240_reg_wr(AR7240_GPIO_OE, gpio_inout_map);          //set desired in/out settings
#endif

    //printf("\n### GPIO_OE_DEBUG=0x%X ###\n",ar7240_reg_rd(AR7240_GPIO_OE));
    //printf("\nbootstrap register (0xb80600ac) = 0x%X ###\n",ar7240_reg_rd(0xb80600ac));

    //printf("\n### AR7240_GPIO_FUNC=0x%X ###\n",ar7240_reg_rd(AR7240_GPIO_FUNC) );

    ar7240_reg_wr (AR7240_GPIO_FUNC, 
        (ar7240_reg_rd(AR7240_GPIO_FUNC) & ~((0x1f<<8)|(0x3<<19))));

    //printf("\n### GPIO_OE_DEBUG=0x%X ###\n",ar7240_reg_rd(AR7240_GPIO_OE));

    /* Enable eth Switch LEDs */
    //DVL: disable eth switch leds, at product norwich no eth led is present (GPIO13 - GPIO17)
    //ar7240_reg_wr (AR7240_GPIO_FUNC, (ar7240_reg_rd(AR7240_GPIO_FUNC) | (0x1f<<3)));

    /* Clear AR7240_GPIO_FUNC BIT2 to ensure that software can control LED5(GPIO16) and LED6(GPIO17)  */
    //DVL: sure?? In the datasheet Bit2 is marked as: Enables UART RTS/CTS I/O on GPIO_11 (RTS) and GPIO_12 (CTS) (p. 92)
    ar7240_reg_wr (AR7240_GPIO_FUNC, (ar7240_reg_rd(AR7240_GPIO_FUNC) & ~(0x1<<2)));

    //printf("\n### GPIO_OE_DEBUG=0x%X ###\n",ar7240_reg_rd(AR7240_GPIO_OE));
	
    /* Set HORNET_BOOTSTRAP_STATUS BIT18 to ensure that software can control GPIO26 and GPIO27 */
    //ar7240_reg_wr (HORNET_BOOTSTRAP_STATUS, (ar7240_reg_rd(HORNET_BOOTSTRAP_STATUS) | (0x1<<18)));

#if 1 //DVL   
    //DVL: User indication: STARTUP LED
    printf("Setup GPIO0 for user status indication\n");
    ar7240_reg_wr (AR7240_GPIO_FUNC2, (ar7240_reg_rd(AR7240_GPIO_FUNC2) & ~(0x1<<10))); //disable the first WLAN LED function on GPIO0
                                                                                        //so it can be controlled by software
    int gpio_high_map = 0x0;                                //map of all gpios set to high state (does not necessarily mean on!)
    gpio_high_map |= (1 << 0);                              //set WLAN LED high for user status indication
    ar7240_reg_wr(AR7240_GPIO_SET, gpio_high_map);


    //DVL: GPIO22 is used to switch on/off AR7420 and
    //should be configured as output and set to low state at the very beginning

    printf("Setup GPIO20/GPIO22 for AR7420\n");
    ar7240_reg_wr (AR7240_GPIO_FUNC1, (ar7240_reg_rd(AR7240_GPIO_FUNC1) & ~(0x1<<29))); //disable I2C on GPIOs 18-22
   
    int gpio_clear_map = 0x0;                               //init map
    gpio_clear_map |= (1 << 20);                            //if set, gpio20 will be cleared in the next reg_wr step
    gpio_clear_map |= (1 << 22);                            //if set, gpio22 will be cleared in the next reg_wr step
    ar7240_reg_wr(AR7240_GPIO_CLEAR, gpio_clear_map);       //clear GPIO20 / GPIO22   

    //printf("\n### GPIO_OE_DEBUG=0x%X ###\n",ar7240_reg_rd(AR7240_GPIO_OE));
    printf("\nbootstrap register (0xb80600ac) = 0x%X ###\n",ar7240_reg_rd(0xb80600ac));
#endif
}

int
ar7240_mem_config(void)
{
    printf("\nbootstrap register (0xb80600ac) = 0x%X ###\n",ar7240_reg_rd(0xb80600ac));
#ifndef COMPRESSED_UBOOT
    unsigned int tap_val1, tap_val2;
#endif
#ifdef CONFIG_HORNET_EMU
    ar7240_ddr_initial_config_for_fpga();
#else
    //ar7240_ddr_initial_config(CFG_DDR_REFRESH_VAL);
#endif

/* Default tap values for starting the tap_init*/
    ar7240_reg_wr (AR7240_DDR_TAP_CONTROL0, CFG_DDR_TAP0_VAL);
    ar7240_reg_wr (AR7240_DDR_TAP_CONTROL1, CFG_DDR_TAP1_VAL);

    ar7240_gpio_config();

#ifndef COMPRESSED_UBOOT
#ifndef CONFIG_HORNET_EMU
    ar7240_ddr_tap_init();

    tap_val1 = ar7240_reg_rd(0xb800001c);
    tap_val2 = ar7240_reg_rd(0xb8000020);
    printf("#### TAP VALUE 1 = %x, 2 = %x\n",tap_val1, tap_val2);
#endif
#endif

    //ar7240_usb_initial_config();
    //DVL: disable ar7240_usb_otp_config();
    //ar7240_usb_otp_config();
    
    hornet_ddr_tap_init();

#if DVL_CONFIG_ENABLE_MEMTEST
	if (run_memtest((datum_t *)CFG_MEMTEST_START, ((CFG_MEMTEST_END) - (CFG_MEMTEST_START))) != 0) //very simple memtest
	{
		//ar7240_reg_wr (AR7240_GPIO_SET, (1 << 16)); //deactivate power led as error indication
		return -1;
	}
#endif

    return (ar7240_ddr_find_size());
}

long int initdram(int board_type)
{
    return (ar7240_mem_config());
}

#ifdef COMPRESSED_UBOOT
int checkboard (char *board_string)
{
#if (BOARD_STRING == WAPI)
    strcpy(board_string, "AP121 (ar9331) U-boot");
#else
    strcpy(board_string, "AP121-2MB (ar9330) U-boot");
#endif
    return 0;
}
#else
int checkboard (void)
{
    printf("AP121-2MB (ar9330) U-boot\n");
    return 0;
}
#endif /* #ifdef COMPRESSED_UBOOT */
